<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UserUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'email'      => [
                'required',
                'string',
                'email',
                'max:255',
                Rule::unique('users')->ignore(request()->segment(2)),
            ],
            //'phone' => 'required|string|max:20|unique:users,phone',
            'phone'      => [
                'required',
                'string',
                'max:255',
                Rule::unique('users')->ignore(request()->segment(2)),
            ],
            'roles' => 'required'
        ];
    }
}
